const FAQ = require("../models/faqModel");
const APIFeatures = require("../utils/ApiFeatures");

// 1. Get All FAQs (Public or Admin)
exports.getAllFAQs = async (req, res) => {
  try {
    const features = new APIFeatures(FAQ.find(), req.query)
      .filter()
      .sort()
      .limitFields()
      .paginate();

    const faqs = await features.query;

    res.status(200).json({
      status: "success",
      results: faqs.length,
      data: { faqs },
    });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

// 2. Get Single FAQ
exports.getFAQ = async (req, res) => {
  try {
    const faq = await FAQ.findById(req.params.id);
    if (!faq) {
      return res.status(404).json({ status: "fail", message: "FAQ not found" });
    }
    res.status(200).json({ status: "success", data: { faq } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

// 3. Create FAQ (Admin Only)
exports.createFAQ = async (req, res) => {
  try {
    const newFAQ = await FAQ.create(req.body);
    res.status(201).json({ status: "success", data: { faq: newFAQ } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

// 4. Update FAQ (Admin Only)
exports.updateFAQ = async (req, res) => {
  try {
    const faq = await FAQ.findByIdAndUpdate(req.params.id, req.body, {
      new: true,
      runValidators: true,
    });

    if (!faq) {
      return res.status(404).json({ status: "fail", message: "FAQ not found" });
    }

    res.status(200).json({ status: "success", data: { faq } });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};

// 5. Delete FAQ (Admin Only)
exports.deleteFAQ = async (req, res) => {
  try {
    const faq = await FAQ.findByIdAndDelete(req.params.id);
    if (!faq) {
      return res.status(404).json({ status: "fail", message: "FAQ not found" });
    }
    res.status(204).json({ status: "success", data: null });
  } catch (err) {
    res.status(400).json({ status: "fail", message: err.message });
  }
};
